
typedef struct program/*#prog_node@*/
{
	UINT32 sat_id/*#masked : 1 | pos : 13@*/;
	UINT32 tp_id/*#masked : 1 | pos : 12@*/;

	UINT32 prog_id;

	//prog feature
	UINT32 level				: 2;
	UINT32 preset_flag 		: 2/*#name : Factory | pos : 11 @*/;
	UINT32 av_flag			: 1/*#name : Service Type | pos : 2 @*/;
	UINT32 ca_mode			: 1/*#name : Scramble | pos : 10 @*/;
	UINT32 video_pid			:13/*#name : Video Pid | pos : 4 @*/;
	UINT32 pcr_pid			:13/*#name : PCR Pid | pos : 8 @*/;

	UINT32 prog_number		:16/*#name : Service ID | pos : 3@*/;
	UINT32 pmt_pid			:13;
	UINT32 tuner1_valid		: 1;
	UINT32 tuner2_valid		: 1;
	UINT32 h264_flag			: 1;
	
	//user setting
	UINT32 fav_grp/*#name : Favorite Group| pos :9 @*/;
//	UINT32 fav_grp0	    		: 1/*#name : Favorite | pos :10 @*/;
//	UINT32 fav_grp1	    		: 7/*#name :  Group| pos : 9 @*/;
//	UINT32 fav_grp2	    		: 1;
//	UINT32 fav_grp3	    		: 1;
//	UINT32 fav_grp4	    		: 1;
//	UINT32 fav_grp5	    		: 1;
//	UINT32 fav_grp6	    		: 1;
//	UINT32 fav_grp7	    		: 1;
//	UINT8 fav_group_byte2		:8;
//	UINT8 fav_group_byte3		:8;
//	UINT8 fav_group_byte4		:8;

	UINT32 pmt_version		: 5;
	UINT32 service_type		: 8;
	UINT32 audio_channel   	: 2/*#name : Audio Mode| pos : 14 @*/;
	UINT32 audio_select		: 1;
		
	UINT32 user_modified_flag: 1;
	UINT32 lock_flag	    		: 1;
	UINT32 skip_flag			: 1;
	UINT32 audio_volume		: 5;
	UINT32 mpeg4_flag			: 1;
	UINT32 nvod_srch_flag	:	1;
	UINT32 signal_type			: 3;
		
	UINT32 hd_flag			: 1;
	UINT32 mheg5_exist		: 1;
	UINT32 LCN_true			: 1;
	UINT16 LCN;
	UINT16 fscan_flg			:1;
	UINT16 reserved			:14;
	UINT16 country			:1;

	UINT32 provider_lock	: 1;
	UINT32 subtitle_pid		:13;
	UINT32 teletext_pid		:13;
	UINT32 cur_audio			: 5;
		
	UINT16 cas_count;
	UINT16 cas_sysid[4];		
	
	UINT16 audio_count;
	UINT16 audio_pid1/*#name : Audio Pid1 | pos : 5 @*/;
	UINT16 audio_pid2/*#name : Audio Pid2 | pos : 6 @*/;	
	UINT16 audio_pid3/*#name : Audio Pid3 | pos : 7 @*/;
  UINT16 audio_pid[17];

	UINT16 audio_lang[20];

	UINT16 name_len;
	UINT8 service_name[66]/*#type : string | name :Service Name | pos : 1@*/;

	UINT16 provider_name_len;
	UINT8 service_provider_name[34];
	
}/*__attribute__((packed))*/ P_NODE;

//max 5
typedef struct tp_node/*#tp_node@*/
{	
	UINT32 sat_id/*#pos : 4@*/;
	UINT32 tp_id/*#pos : 1@*/;

	UINT32 frq				:32/*#pos : 2@*/;
	UINT16 sym				:16/*#pos : 3@*/;

	UINT16 pol					: 2/*#pos : 5@*/;
	UINT16 FEC_inner				: 4;
	UINT16 universal_22k_option	: 1;
	UINT16 Big5_indicator			: 1; 
	
	UINT16 inverse				: 1; 	/*used for channel change*/
	UINT16 band_type				: 1;	/*0: VHF, 1: UHF, for DVB-T only*/
	UINT16 ft_type				: 2;//front end type,check lib_frontend.h        
	UINT16 tp_t2_s2					: 1;	/*wxw 2011-03-04*/
	UINT16 selected_flag			: 1;	/*110630 dym*/
	UINT16 reserved1				: 2;

	UINT16 guard_interval		:8; 	/*0x4: 1/4, 0x8: 1/8, 0x10: 1/16, 0x20:1/32*/
	UINT16 FFT				:8;	/*0x2 : 2k, 0x8 : 8k*/
	UINT16 modulation			:8;	/*0x4 : QPSK, 0x10 : 16 QAM, 0x40 : 64 QAM*/
	UINT16 bandwidth			:8;	/**/

	UINT16 sdt_ver				:5;	 //crb add 2010/08/17
	UINT16 pat_ver				:5;   //crb add 2010/08/17
	UINT16 nit_ver        :5;    //crb add 2010/11/26
	UINT16 reserved3			:1;   //crb add 2010/08/17		

	UINT16 preset_flag				: 2;
	UINT16 usage_status			: 1;
	UINT16 nit_pid				:13;
		
	UINT32 t_s_id				:16;
	UINT32 network_id			:16;
}/*__attribute__((packed))*/ T_NODE;

//max 12
typedef struct sat/*#sat_node@*/
{
	//for db index
	UINT32 sat_id/*#pos : 2@*/;
	
	UINT16 sat_orbit/*#pos : 7@*/;
	
	UINT16 selected_flag	: 1/*#pos : 13@*/;
	UINT16 tuner1_valid	: 1/*#pos : 14@*/;
	UINT16 tuner2_valid	: 1/*#pos : 15@*/;
	UINT16 reserve_1		: 13;
	
	//tuner1 antenna setting*****
	UINT8 lnb_power		: 1;
	UINT8 lnb_type		: 7/*#pos : 3@*/;	

	UINT8 pol			: 2;
	UINT8 k22			: 1/*#pos : 9@*/;
	UINT8 v12			: 1/*#pos : 8@*/;
	UINT8 toneburst		: 2/*#pos : 10@*/;	
	UINT8 reserve_2		: 2;
	
	UINT16 lnb_low/*#pos : 5@*/;
	UINT16 lnb_high/*#pos : 4@*/;

	UINT8 DiSEqC_type	: 4/*#pos : 11@*/;
	UINT8 DiSEqC_port 	: 4/*#pos : 12@*/;
	
	UINT8 DiSEqC11_type	: 4;
	UINT8 DiSEqC11_port 	: 4;
		
	UINT16 positioner_type	: 3;	
	UINT16 position		: 8/*#pos : 6@*/;
	UINT16 reserve_3		: 5;
	//*************************
	
	UINT8 lnb_power_2		: 1;
	UINT8 lnb_type_2		: 7;	

	UINT8 pol_2			: 2;
	UINT8 k22_2			: 1;
	UINT8 v12_2			: 1;
	UINT8 toneburst_2		: 2;	
	UINT8 reserve_1_2		: 2;
	
	UINT16 lnb_low_2;
	UINT16 lnb_high_2;

	UINT8 DiSEqC_type_2	: 4;
	UINT8 DiSEqC_port_2 	: 4;
	
	UINT8 DiSEqC11_type_2	: 4;
	UINT8 DiSEqC11_port_2 	: 4;
		
	UINT16 positioner_type_2	: 3;	
	UINT16 position_2		: 8;
	UINT16 reserve_2_2		: 5;
	
	UINT16 name_len;
	UINT8 sat_name[34]/*#name :satname | type :string | pos : 1@*/;

}/*__attribute__((packed))*/ S_NODE;


